patches-own
[
  new-color       ;; aktuln nov barva - vdy ern nebo bl
  inner-neighbors ;; ostatn buky ve vnitnm kruhu kolem centrln buky
  outer-neighbors ;; ostatn buky v prstenci kolem centrln buky (vtinou bez bunk, kter by se pmo dotkaly)
]

to setup
  clear-all
  ;; vypot vnitn a vnj sousedy v elipse kolem buky
  ask patches
  [
    set inner-neighbors ellipse-in vnitrni-radius-x vnitrni-radius-y
    ;; vnj soused potebuj vce vpot nebo chceme zskat pouze samotn prstenec, nikoliv cel kruh
    set outer-neighbors ellipse-ring vnejsi-radius-x vnejsi-radius-y vnitrni-radius-x vnitrni-radius-y
  ]

  ifelse any? patches with [ count outer-neighbors = 0 ]
    [ user-message word " Nastaven, ve kterm je VNJ stejn velk nebo men ne VNIT, nedv smysl "  
                        " Prosm, zmte hodnoty posvnk a stisknte tlatko PIPRAV "
      stop]
    [restart]
end

;; tato procedura nastav procento blch bunk pibln podle hodnoty POCATECNI-HUSTOTA 
;; a zbytek nastav ern. Pokud je POCATECNI-HUSTOTA na 50%, pak je polovina bunk
;; bl a polovina ern
to restart
  reset-ticks
  ask patches
    [ ifelse random-float 100.0 < pocatecni-hustota
        [ set pcolor white ]
        [ set pcolor black ] ]
end

to go
  ask patches [ pick-new-color ]
  ask patches [ set pcolor new-color ]
  tick
end

to pick-new-color  ;; procedura polek
  let activator count inner-neighbors with [pcolor = white]
  let inhibitor count outer-neighbors with [pcolor = white]
  ;; nemusme zde nsobit "activator" dnm koeficientem, protoe 
  ;; parametr POMER dr neporuenou proporci promnnch 
  let difference activator - pomer * inhibitor
  ifelse difference > 0
    [ set new-color white ]
    [ if difference < 0
        [ set new-color black ] ]
  ;; vimnte si, e jsme neoetili ppad, kdy difference = 0
  ;; to je tm, e v tomto ppad nechceme, aby dolo ke zmn barvy
end

;;; procedury pro definovn chovn soused v eliptickm okol

to-report ellipse-in [x-radius y-radius]  ;; procedura polek
  report patches in-radius (max list x-radius y-radius)
           with [1.0 >= ((xdistance myself ^ 2) / (x-radius ^ 2)) +
                        ((ydistance myself ^ 2) / (y-radius ^ 2))]
end

to-report ellipse-ring [outx-radius outy-radius inx-radius iny-radius]  ;; procedura polek
  report patches in-radius (max list outx-radius outy-radius)
           with [1.0 >= ((xdistance myself ^ 2) / (outx-radius ^ 2)) +
                        ((ydistance myself ^ 2) / (outy-radius ^ 2))
             and 1.0 <  ((xdistance myself ^ 2) / (inx-radius ^ 2)) +
                        ((ydistance myself ^ 2) / (iny-radius ^ 2))
                ]
end

;; Nsledujc dva reportery vrac hodoty x a y vzdlenost.
;; Lze si je pedstavit jako vzdlenosti vrchol trojhelnku, 
;; urujc "jak daleko do leva" a "jak daleko nahoru" jsou 
;; zbvajc vrcholy od prvnho vrcholu. Tato sla jsou dleit pro 
;; vpoet v eliptickm okol buky. 
  
;; Vimnte si, e je dleit pout primitivum DISTANCEXY a nikoliv
;; pouze absolutn hodnotu rozdlu v souadnicch. Je to tak, protoe
;; DISTANCEXY zachz s volnmi (prchozmi) okraji okna sprvn, pokud
;; je tato prchodnost zapnuta (co ve standardnm nastaven tohoto modelu je).

to-report xdistance [other-patch]  ;; procedura polek
  report distancexy [pxcor] of other-patch
                    pycor
end

to-report ydistance [other-patch]  ;; procedura polek
  report distancexy pxcor
                    [pycor] of other-patch
end


; *** NetLogo 4.0.3 Model Copyright Notice ***
;
; This model was created as part of the projects:
; PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING IN
; CLASSROOMS and/or INTEGRATED SIMULATION AND MODELING ENVIRONMENT.
; The project gratefully acknowledges the support of the
; National Science Foundation (REPP & ROLE programs) --
; grant numbers REC #9814682 and REC-0126227.
;
; Copyright 2003 by Uri Wilensky.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (2003).  NetLogo Fur model.
; http://ccl.northwestern.edu/netlogo/models/Fur.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 2003 Uri Wilensky.  All rights reserved.
; See http://ccl.northwestern.edu/netlogo/models/Fur
; for terms of use.
;
; *** End of NetLogo 4.0.3 Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
309
10
624
346
30
30
5.0
1
10
1
1
1
0
1
1
1
-30
30
-30
30
1
1
1
ticks

CC-WINDOW
5
360
633
455
Command Center
0

BUTTON
205
60
294
93
Piprav
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
218
254
289
287
Start
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
7
221
179
254
pocatecni-hustota
pocatecni-hustota
0
100
50
1
1
%
HORIZONTAL

SLIDER
7
257
180
290
pomer
pomer
0
2
0.35
0.01
1
NIL
HORIZONTAL

BUTTON
217
216
290
249
1x Krok
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
216
179
289
212
Restart
restart
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
8
37
180
70
vnitrni-radius-x
vnitrni-radius-x
0
10
3
1
1
cells
HORIZONTAL

SLIDER
8
72
180
105
vnitrni-radius-y
vnitrni-radius-y
0
10
3
1
1
cells
HORIZONTAL

SLIDER
7
106
180
139
vnejsi-radius-x
vnejsi-radius-x
0
10
6
1
1
cells
HORIZONTAL

SLIDER
7
141
179
174
vnejsi-radius-y
vnejsi-radius-y
0
10
6
1
1
cells
HORIZONTAL

@#$#@#$#@
CO TO JE?
---------

Me existovat jeden jedin mechanismus, kter by dokzal vytvet takov zvec zbarven, jako jsou zeb pruhy, skvrny leoparda nebo vzory na tle irafy? Tento model nabz mon vysvtlen, jak se mohou vzory zvec ke samoorganizovat. Pokud je tento model sprvn, pak formovn zvecch vzor zpsobuj stejn pravidla, kter se pouze u jednotlivch zvat li nktermi hodnotami parametr (se ktermi tato pravidla pracuj).

Zkoumnm formovn vzor v podob pravidel i zkonitost nm me tak pomoci pochopit, jak me dochzet k vytven rozdlnch vzor mezi jednotlivmi zvaty a jejich potomstvem. Potomci maj zpravidla sice podobn vzor, avak nikoliv zcela identick. To je zpsobeno tm, e dd od svch rodi spe soubor pravidel a hodnot namsto nemnnho obrazce. Proces, pi kterm tato pravidla a hodnoty vytv vzory, je ovlivnn nhodnmi faktory, m dochz k jedinenm vzorm na kadm jedinci. Tak dlouho, jak bude potomstvo ddit tato pravidla a hodnoty, tak se bude dlouho jejich zbarven samoorganizovat do stejnch vzor, jako mli jejich rodie. 

JAK TO FUNGUJE?
---------------

Zvec ke je v tomto modelu vytvena skupinami malch tverc pedstavujcch melanocyty (pigmentov buky), kter se mohou nachzet ve dvou odlinch stavech: zbarven (dle jen Z) a bezbarv (dle jen B). Stav buky se me mnit mezi Z a B. Zbarven buky (Z) vyluuj dva typy morfogen: aktivtory (A) a inhibitory (I). Aktivtory zpsobuj zbarven centrln buky, inhibitory zase naopak zpsobuj, e centrln buka bude bezbarv. Tyto vzjemn si konkurujc morfogeny jsou vyluovny vemi smry, m kolem sebe vytv centrln buka pomyslnou skvrnu, kter se roziuje k ostatnm bukm.

Kad z bunk (a u zbarven nebo bezbarv) je sama centrem svho vlastnho okol. Nyn pedpokldejme, e toto okol m tvar kruhu. eknme, e toto okol m rdius (polomr) 6 bunk. To znamen, e buka v centru je ovlivnna vemi ostatnmi bukami, kter le v dosahu 6 bunk v jakmkoliv smru. Pokud je tedy v tomto okruhu Z buka vypoutjc morfogeny, pak se morfogeny roz a k tto centrln buce (avak Z buka ve vzdlenosti 7 bunk tuto centrln buku pmo neovlivn). Zrove m ovem kad z bunk vnitn kruhov okol, jeho rdius je eknme 3 buky.

Buky typu Z nachzejc se ve vnitnm kruhu psob na centrln buku morfogenem A (aktivtorem). Mezi vnitnm kruhem a okrajem vnjho le prstenec bunk, kter jsou vzdlen vce ne 3 ale mn ne 7 od centrln buky. Kad Z buka v tomto vnjm prstenci psob na centrln buku naopak morfogeny I (inhibitory). Dky tomu je v kadm okamiku kad buka ovlivnna aktivtory a inhibitory ze svho okol a otzka zn, zda nakonec pev aktivtory a buka se zbarv, nebo naopak inhibitory a buka ztrat barvu (nebo pouze zstane v pvodnm stavu). Logika spov v tom, e pokud je sla aktivtor silnj ne sla inhibitor, pak se buka zbarv a naopak (pokud jsou ob sly v rovnovze, dn zmna nenastane). Zmnn mylenka sly spov v tom, e nesta znt prost poet morfogen obou druh psobcch na buku, nbr je teba psoben kad buky nsobit jej silou (nebo je mon tuto slu chpat jako koncentraci morfogen ve vnitnm a vnjm okol). Dal mylenka je, e pokud budeme nsobit oba typy morfogen jejich silou, meme vyjdit slu aktivtor jako 1 a slu inhibitor jako 1 * w nebo pouze w. W je tedy pomr mezi silou inhibitor a aktivtor. Pokud je w vt ne jedna, znamen to, e sla inhibitor je vt ne sla aktivtor (kdy je napklad w = 2, pak jsou inhibitory dvakrt silnj ne aktivtory; a pro w = 0,5 maj inhibitory polovin slu ne aktivtory). Pokud je tedy w = 0,5 a mme stejn poet inhibitor jako aktivtor psobcch na centrln buku, pak logicky pedpokldme, e centrln buka bude vce aktivovna ne inhibovna, a proto se v modelu v tomto asovm kroku zbarv. (Dleit je si uvdomit, e ve chvli, kdy nkter Z buka aktivuje sousedn buky, tato Z buka zrove inhibuje o nco vzdlenj buky.)

Ve uveden pravidla lze shrnout nsledujcm zpsobem: Spotaj se vechny Z buky ve vnjm prstenci a toto slo se ozna jako Z*I (napklad 2 inhibitory). Dle se spotaj vechny Z buky ve vnitnm kruhu a ozna se jako Z*A (napklad 5 aktivtor). Pot vypoteme Z*A - w*Z*I a. Pokud je vsledek > 0, nastav se centrln buka do stavu Z; pokud je vsledek > 0, nastav se centrln buka do stavu B; pokud je vsledek = 0, zstane centrln buka beze zmny.

Podstatn je, e tento vpoet probh pro vechny buky ve stejnou chvli. Po dokonen prvnho kroku, ve kterm se vechny buky nastav do pslunch stav, se cel proces opakuje znovu. Opt jsou pepotny stavy jednotlivch bunk podle stejnch pravidel. Pravidla se sice nemn, avak nkter z bvalch Z bunk jsou nyn ve stavu B a naopak, co me mt za nsledek odlin vsledek - rozdln vsledek souboje mezi morfogeny A a I.

V modelu tedy vidte krok za krokem jednotliv buky mnit barvu z bl (reprezentujc Z buky) na ernou (reprezentujc B buky) a celkov dojem se projevuje zmnami celho uspodn bl a ern barvy. Avak tato uspodn nejsou nhodn. asto uvidte, jak se tato uspodn formuj. Pochopen chovn kad buky, vysvtlen ve, nm me pomoci porozumt, jak se vytv celkov vzory.

Vechna uveden vysvtlen se tkala kruhovho okol buky. V tomto modelu me bt ovem okol buky nejen kruhov ale tak eliptick. Pomoc eliptickho okol lze vytvoit mimo skvrn tak pruhov vzory. 

JAK MODEL OVLDAT
-----------------

Pokud chcete, aby v prvn experiment s modelem zhruba odpovdal ve uvedenmu popisu, nastavte posuvnk POCATECNI-HUSTOTA na hodnotu 50 % (tm dte kad z bunk stejnou anci na to, aby se zbarvila ern nebo ble, a tud bude cel okno piblin z 50 % bl), posuvnky VNITRNI-RADIUS-X a VNITRNI-RADIUS-Y na 3 a posuvnky VNEJSI-RADIUS-X a VNEJSI-RADIUS-Y na 6 a POMER na hodnotu 0,35 (to znamen, e morfogeny I jsou z 35 % tak siln jako morfogeny A). Nyn stisknte tlatko PIPRAV. (V dalch experimentech si zkuste zmnit tato nastaven na rzn dal kombinace.) Me chvilku trvat, ne se model piprav. Pokud pot stisknte tlatko 1x KROK, posunete model o jednu asovou jednotku. Stisknutm tlatka START spustte model v nepetritm bhu asovch krok.

Polkm chvli trv, ne ovlivn sv sousedy. Z toho dvodu pouvejte tlatko PIPRAV, pokud zmnte hodnoty posuvnk urujc rdius. Pokud chcete pouze zmnit hodnoty posuvnk POCATECNI-HUSTOTA a POMER nebo pokud chcete spustit model s identickm nastavenm, stisknte tlatko RESTART namsto tlatka PIPRAV. Samotn stisknut tlatka RESET nepepot okol pro jednotliv polka. 

VIMNTE SI
-----------

Za bhu modelu mohou vznikat vzory, kter se mohou stabilizovat (pestoe se obas dostane do nekonen oscilace mezi dvma stavy, co ovem meme nazvat dynamickou stabilitou). Pestoe to vypad, e se bh modelu zastavil, model stle b s vykonvnm vech pkaz a vpot - dn z nich se vak viditeln neprojev. To proto, e pro kadou buku jsou aktivtory a inhibitory v rovnovze a tud se nemn. 

VYZKOUEJTE SI
--------------

Spuste model s rznmi hodnotami posuvnku POCATECNI-HUSTOTA. Jak (pokud vbec) ovlivn hodnota tohoto nastaven vytven vzor? Vzniknou stejn vzory jako minule? Nebo vzniknou odlin? Trv tento proces dle?

Vimnte si, jak je samoorganizace bunk citliv na mal zmny parametr. Pokud ponechte vechny ostatn faktory nezmnn a budete mnit pouze hodnotu posuvnku POMER, uvidte, e u nzkch hodnot dostanete vdy zcela bl okno a u vysokch hodnot zase naopak zcela ernou plochu (pro?). Pro stedn hodnoty dochz k fluktuaci vzniklch vzor. To je dno prvotnm zbarvenm, kter do modelu pin nhodn prvek (prohldnte si proceduru RESTART v kdu).

Zkuste zmnit hodnoty posuvnk tak, abyste mli odlin hodnoty X a Y u parametr, kter uruj rdius bunk. 

ROZEN MODELU
----------------

Pokud naleznete takovou kombinaci hodnot parametr, kter konzistentn vytv vzory ke njakho oblbenho zvete, mete pro ni vytvoit vlastn tlatko, napklad Zebra, kter nastav posuvnky prv na tyto vybran hodnoty. Tmto zpsobem (pokud jich vytvote vce) si mete pomoc pepnn vzor projt v modelu svoje vlastn safari. Jedna z kombinac, kterou si mete nastavit na samostatn tlatko, je tato: VNITRNI-RADIUS-X 3 VNITRNI-RADIUS-Y 3 VNEJSI-RADIUS-X 6 VNEJSI-RADIUS-Y 6 POCATECNI-HUSTOTA 50% POMER 0,35.

Toto tlatko mete nazvat teba Ryba.

A co pidn dalch barev? Co by zde bylo logick? Pokud byste pidali napklad ervenou, mli byste se rozhodnout, za jakch specifickch podmnek by se mla objevovat. Stejn tak byste mli rozhodnout, jak tato nov barva bude ovlivovat ostatn barvy. 

SOUVISEJC MODELY
------------------

Model Voting (volby) v sekci Social Science (spoleensk vdy) je zaloen na jednoduch pravidlech. Vytv ovem vzory, kter jsou v jistch ohledech tomuto modelu podobn.


PODKOVN A ODKAZY
----------------------
Mechanismus "rozptylem zen nestability" byl poprv navren Alanem Turingem v roce 1952. B.N. Nagorcka prvn navrhl jeho vyuit na oblast rstu vlas a srsti. Jednotliv varianty prezentovan v tomto modelu byly navreny Davidem Youngem.

Pi vytven modelu jsme pouili informace dostupn na tto strnce:
http://classes.yale.edu/fractals/Panorama/Biology/Leopard/Leopard.html

Podkovn za prci na tomto modelu pat tak Seth Tisue a Dor Abrahamson.

Pi citovn tohoto modelu ve vdeckch publikacch pouijte prosm nsledujc odkaz:  Wilensky, U. (2003).  NetLogo Fur model.  http://ccl.northwestern.edu/netlogo/models/Fur.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

V jinch publikacch uvete prosm tyto informace: Copyright 2003 Uri Wilensky.  All rights reserved.  See http://ccl.northwestern.edu/netlogo/models/Fur for terms of use.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
